!define APPLANG "De"
!define FULLNAME "FirefoxPortable"
!define NAME "FirefoxPortable"
!define APP "Firefox"
!define VER "1.0.0.0"
!define WEBSITE "http://regcheck.blogger.de"
!define DEFAULTEXE "firefox.exe"
!define DEFAULTAPPDIR "Firefox"
;=== Program Details
Name "${NAME}"
OutFile "${NAME}.exe"
Caption "${FULLNAME}"
VIProductVersion "${VER}"
VIAddVersionKey FileDescription "${FULLNAME}"
VIAddVersionKey ProductName "FireFoxPortable"
VIAddVersionKey LegalCopyright "RegCheck"
VIAddVersionKey FileVersion "${VER}"
VIAddVersionKey ProductVersion "${VER}"
VIAddVersionKey InternalName "FireFoxPortable"
VIAddVersionKey LegalTrademarks "FireFox is a Trademark of The Mozilla Foundation."
VIAddVersionKey OriginalFilename "${NAME}.exe"
;=== Runtime Switches
CRCCheck Off
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True
RequestExecutionLevel user
;=== Program Icon
Icon "${NAME}.ico"
Var PROGRAMDIRECTORY
Var PROFILEDIRECTORY
Var ALLOWMULTIPLEINSTANCES
Var EXECSTRING
Var WAITFORPROGRAM
Var PROGRAMEXECUTABLE
Var ISFILELINE
Var SKIPCHROMEFIX
Var SKIPCOMPREGFIX
Section "Main"
StrCpy "$ALLOWMULTIPLEINSTANCES" "true"
StrCpy "$WAITFORPROGRAM" "false"
StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"	
StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\${DEFAULTAPPDIR}"
StrCpy "$PROFILEDIRECTORY" "$EXEDIR\Profilordner"
StrCpy $SKIPCHROMEFIX "true"
StrCpy $SKIPCOMPREGFIX "true"

IfFileExists "$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" FoundProgramEXE
NoProgramEXE:
MessageBox MB_OK|MB_ICONEXCLAMATION `$PROGRAMEXECUTABLE nicht gefunden`
Abort		
FoundProgramEXE:
StrCmp $ALLOWMULTIPLEINSTANCES "false" ProfileWork

ProfileWork:
IfFileExists "$PROFILEDIRECTORY\prefs.js" ProfileFound
;=== Kein Profil gefunden
MessageBox MB_YESNO|MB_ICONQUESTION `Kein Profil gefunden. Neues erstellen? $\n$PROFILEDIRECTORY\` IDYES CreateProfile
MessageBox MB_OK|MB_ICONINFORMATION `${NAME} erstellt.`
Abort
	
CreateProfile:	
CreateDirectory "$PROFILEDIRECTORY"

ProfileFound:
	
NextLine:
FileWrite $R0 $4
FileRead $0 $4
IfErrors NoMoreLines ;== we've reached the end of the file
StrCpy $5 $4 35
StrCmp $5 `                   c:baseURL="jar:f` FoundJarLine
StrCmp $5 `                   c:baseURL="file:` FoundFileLine NextLine

FoundJarLine:
StrCpy $R4 40
StrCpy $ISFILELINE "0"
GoTo NotYet

FoundFileLine:
StrCpy $R4 40
StrCpy $ISFILELINE "1"

NotYet:
IntOp $R4 $R4 + 1
StrCpy $7 $4 10 $R4 

;=== looking for the point to strip the extension path
StrCmp $7 "extensions" PathFound NotYet
	
PathFound:
StrCpy $5 $4 "" $R4
StrCmp $ISFILELINE "0" MakeJarLine MakeFileLine

MakeJarLine:
StrCpy $4 `                   c:baseURL="jar:file:///$PROFILEDIRECTORY/$5`
GoTo NextLine

MakeFileLine:
StrCpy $4 `                   c:baseURL="file:///$PROFILEDIRECTORY/$5`
GoTo NextLine

NoMoreLines:
FileClose $0
FileClose $R0

	
CMNextLine:
FileWrite $R0 $4
FileRead $0 $4
IfErrors CMNoMoreLines 
;== we've reached the end of the file
StrCpy $5 $4 28
StrCmp $5 `                   NC:path="` "" CMNextLine
StrCpy $R4 28
	
CMNotYet:
IntOp $R4 $R4 + 1
StrCpy $7 $4 9 $R4 ; looking for the point to strip the calendar path
StrCmp $7 "Calendar\" "" CMNotYet
StrCpy $5 $4 "" $R4
StrCpy $4 `                   NC:path="$PROFILEDIRECTORY\$5` ;=== the adjusted extension path
GoTo CMNextLine

CMNoMoreLines:
FileClose $0
FileClose $R0

RunProgram:
;=== Delete component registry to ensure compatibility with all extensions
		
Delete $PROFILEDIRECTORY\compreg.dat

GetPassedParameters:
;=== Get any passed parameters
Call GetParameters
Pop $0
StrCmp "'$0'" "''" "" LaunchProgramParameters

;=== No parameters
StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" -no-remote -profile "$PROFILEDIRECTORY"`
Goto CheckMultipleInstances

LaunchProgramParameters:
StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" -no-remote -profile "$PROFILEDIRECTORY" $0`

CheckMultipleInstances:
StrCmp $ALLOWMULTIPLEINSTANCES "false" "" AdditionalParameters
System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("MOZ_NO_REMOTE", "1").r0'

AdditionalParameters:

;=== Additional Parameters

PluginsEnvironment:
;=== Set the plugins directory if we have a path
StrCmp $PLUGINSDIRECTORY "" UserProfileEnvironment
IfFileExists "$EXEDIR\$PLUGINSDIRECTORY\*.*" "" UserProfileEnvironment
System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("MOZ_PLUGIN_PATH", "$EXEDIR\$PLUGINSDIRECTORY").r0'

UserProfileEnvironment:

LaunchNow:
StrCmp $WAITFORPROGRAM "true" LaunchAndWait LaunchAndClose

LaunchAndWait:
ExecWait $EXECSTRING
GoTo TheEnd

LaunchAndClose:
Exec $EXECSTRING
		
RMDir "$APPDATA\Mozilla\Firefox\" ;=== Will only delete if empty (no /r switch)
RMDir "$APPDATA\Mozilla\" ;=== Will only delete if empty (no /r switch)

TheEnd:

SectionEnd

Function "GetParameters"
 Push $R0
 Push $R1
 Push $R2
 StrCpy $R0 $CMDLINE 1
 StrCpy $R1 '"'
 StrCpy $R2 1
 StrCmp $R0 '"' loop
 StrCpy $R1 ' ' ; we're scanning for a space instead of a quote
loop:
 StrCpy $R0 $CMDLINE 1 $R2
 StrCmp $R0 $R1 loop2
 StrCmp $R0 "\" "" "nofile"
 IntOp $2 $R2 + 1
nofile:
;MessageBox MB_OK "r0: $R0"
 StrCmp $R0 "" loop2
 IntOp $R2 $R2 + 1
 Goto loop
loop2:
 IntOp $R0 $R2 - $2
 IntOp $R0 $R0 - 4
;MessageBox MB_OK "$R2 - $2 = $R0"
 StrCpy $R7 $CMDLINE $R0 $2 ; we save the filename
;MessageBox MB_OK "$2"
 loop2b:
 IntOp $R2 $R2 + 1
 StrCpy $R0 $CMDLINE 1 $R2
;MessageBox MB_OK "rr0: $R0"
 StrCmp $R0 " " loop2b
 StrCpy $R0 $CMDLINE "" $R2
 Pop $R2
 Pop $R1
 Exch $R0
FunctionEnd