
Option Explicit

Dim listArgs

Dim gobjWSHShell
Dim gobjFileSystem
Dim gobjM3UFile

Dim gstrFolder

' Schlssel in der Register-Dankenbank zu Integration im Kontextmen
Const constRegKey = "HKEY_CLASSES_ROOT\Folder\shell\M3U generieren\"
Const constRegKeyUninstall = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\createM3U\"


' Notwendige Objekte
Set gobjWSHShell = WScript.CreateObject("WScript.Shell")
Set gobjFileSystem = CreateObject("Scripting.FileSystemObject")

' Uebergebenes Argument auslesen
Set listArgs = WScript.Arguments

If listArgs.Count = 0 Then
   ' Wenn kein Parameter: Installation 
   installSkript
Else
    If listArgs(0) = "-deinstall" Then
        ' Skript deinstallieren
        deinstallSkript
    Else
        ' Uebergebenen Ordner lesen
        gstrFolder = listArgs(0)
        createM3U gstrFolder
    End If   
End If
   
Set listArgs = Nothing
Set gobjWSHShell = Nothing
Set gobjFileSystem = Nothing

' Skript beenden
Wscript.Quit



'
' Funktion: createM3U()
' ---------------------------

Function createM3U (strFolder)

    Dim strM3UFile
    Dim objFolder

    If gobjFileSystem.FolderExists(strFolder) Then

        ' Objekt fuer den uebergebenen Ordner erzeugen
        Set objFolder = gobjFileSystem.GetFolder(strFolder)

        ' Name der M3U-Datei erzeugen
        strM3UFile = strFolder & "\" & objFolder.Name & ".m3u"

        ' Objekt fuer die M3U-Datei erzeugen und Datei oeffnen
        Set gobjM3UFile = gobjFileSystem.CreateTextFile(strM3UFile,true)

        ' MP3-Dateien in die M3U-Datei schreiben
        listFiles objFolder.path

        ' M3U-Datei schliessen
        gobjM3UFile.Close
        Set gobjM3UFile = Nothing

    else
        MsgBox "Angegebener Ordner " & strFolder & " existiert nicht!"
    End If   
      
End Function


'
' Funktion: listFiles()
' ---------------------------

Function listFiles(strFolder)

    Dim objFolder
    Dim objSubFolder
    Dim objFile
    
    If gobjFileSystem.FolderExists(strFolder) Then

        Set objFolder = gobjFileSystem.GetFolder(strFolder)
        For Each objFile In objFolder.Files
            If UCase(Right(objFile.Name,4)) = ".MP3" Then
                gobjM3UFile.Write Replace(objFile.Path, gstrFolder, ".") & vbNewLine
            End If
        Next

        For Each objSubFolder In objFolder.SubFolders
            listFiles objSubFolder.path
        Next

    else
        MsgBox "Angegebener Ordner " & strFolder & " existiert nicht!"
    end if

end function

'
' Funktion: installSkript()
' ---------------------------

Function installSkript ()

   If (MsgBox("Das Skript ins Kontextmen einbinden?", vbYesNo + vbQuestion, "Installation?")=vbYes) Then
   
      ' Befehl ins Kontextmen einer EXE-Datei, eines Ordner und eines Laufwerkes hngen...
      gobjWSHShell.RegWrite constRegKey & "command\", """" & WScript.Fullname & """ """ & WScript.ScriptFullName & """ ""%1"""
      
      ' Installationsinformationen fr die Systemsteuerung schreiben...
      gobjWSHShell.RegWrite constRegKeyUninstall & "DisplayName", "VBSkript CreateM3U"
      gobjWSHShell.RegWrite constRegKeyUninstall & "DisplayVersion", "1.0"
      gobjWSHShell.RegWrite constRegKeyUninstall & "HelpLink", "http://www.homepage.de"
      gobjWSHShell.RegWrite constRegKeyUninstall & "Publisher", "Alex"
      gobjWSHShell.RegWrite constRegKeyUninstall & "UninstallString", """" & WScript.Fullname & """ """ & WScript.ScriptFullName & """ ""-deinstall"""
      
      ' Fertig!
      MsgBox "Das Skript """ & WScript.ScriptName & """ wurde im Kontextmen integriert!"
      
   End If
      
End Function

'
' Funktion: deinstallSkript()
' ---------------------------

Function deinstallSkript ()

   If (MsgBox("Das Skript deinstallieren?", vbYesNo + vbQuestion, "Deinstallieren?")=vbYes) Then
   
      ' Integration ins Kontextmen entfernen
      gobjWSHShell.RegDelete constRegKey & "command\"
      gobjWSHShell.RegDelete constRegKey 

      ' Deinstallationsinformationen lschen
      gobjWSHShell.RegDelete constRegKeyUninstall 
      
   End If
   
End Function

